//===============================================================================================
// Objects:			zTocSection and zTocItem
// Description:	Help objects used to generate a help table of content (TOC) page
//						(Help center, video library) from XML description of its contents.
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================

var kTocColCnt = 4;
var gTocIdCnt = 0;

//-----------------------------------------------------------------------------------------------
function appendToc( l, filename, variant, channel, useButtons )
	// Create and append the HTML elements for the TOC into the specified element
{
	if( !l ) return;
	
	// Read in the definition from the XML
	var sections = getTocSections( filename );
	if( !sections ) return;
	
	var bButtons = (useButtons) ? true : false;
		
	// Render each section	
	// Create the item links for each section in 2 columns
	var tbl = document.createElement("table");
	l.appendChild( tbl );
	tbl.cols = kTocColCnt;
	tbl.cellSpacing = 0;
	tbl.cellPadding = 0;
	tbl.border = 0;
	tbl.width="100%";
		
	// Create and append the HTML elements for each section
	var cnt = sections.length;
	var rowCnt = 0;
	var j,cells, cellsCnt;
	var row, cell;
	var bItemsAdded = false;
	
	for( var i=0; i<cnt; ++i )
	{
		bItemsAdded = appendTocSection( tbl, sections[i], variant, channel, bButtons );
		if( bItemsAdded )
		{
			// Add an empty row for padding between sections
			row = tbl.insertRow();
			row.vAlign = "top";
			cell = row.insertCell();
			cell.className = "endSection";
			cell.colSpan = kTocColCnt;
			cell.innerHTML = "&nbsp;";
			if (bButtons)
			{
				row = tbl.insertRow();
				cell=row.insertCell();
				cell.className="separator";
			}
		}	
	}
	
}
	
//-----------------------------------------------------------------------------------------------
function appendTocSection( tbl, section, variant, channel, useButtons )
	// Create and append the HTML elements for the section into the specified element
{
	if( !tbl || !section || !section.items ) return false;


	// Check if there are applicable items
	var bHasItems = false;
	var cnt = section.items.length;
	for( var i=0; i<cnt; ++i )
	{
		if( section.items[i].isApplicable( variant, channel ) )
		{
			bHasItems = true;
			break;
		}
	}
	if( !bHasItems ) return false;
	// Add the section contents
	var row = null, cell = null;
	
	if( section.title )
	{
		row = tbl.insertRow();	
		cell = row.insertCell();
		cell.className = "sectionHeader";
		if (!useButtons)
			cell.colSpan = kTocColCnt;
		cell.noWrap = true;
		cell.innerHTML = section.title;
		if (useButtons)
		{
			row = tbl.insertRow();
			cell=row.insertCell();
			cell.className="separator";
		}
	}
	var bLeft = true;
	var bFullRow = false;
	var bAddVideoRow = false;
	var k = 0;

	for( var i=0; i<cnt; ++i )
	{
		if( !section.items[i].isApplicable( variant, channel ) ) continue;
		
		bFullRow = false;
		if( section.items[i].bFullRow )
		{
			bFullRow = true;
			bLeft = true;
		}

		if( bLeft || !row )
		{
			if( bAddVideoRow )
			{
				bAddVideoRow = false;
				addVideoRow( tbl );
			}
	
			row = tbl.insertRow();
			row.vAlign = "top";
		}

		if (!useButtons)
		{
			// bullet
			cell = row.insertCell();
			cell.className = "bullet";
			cell.innerHTML = "&#108;";
			cell.style.paddingLeft = "20px";

			// link
			cell = row.insertCell();
			cell.className = "tocItem";
			if( bFullRow ) cell.colSpan = kTocColCnt - 1;
			else cell.width = "48%";		
			cell.innerHTML = renderTocItem( section.items[i] );
			if( section.items[i].video ) bAddVideoRow = true;
		}
		else
		{
			// table data.
			cell = row.insertCell();
			cell.className = "buttonCell";
			cell.width = "100%";
			cell.innerHTML = renderTocButton( section.items[i] );
		}

		bLeft = !bLeft;
		if( bFullRow ) bLeft = true;
	}

	if( bAddVideoRow ) addVideoRow( tbl );
	
	return true;
}

//-----------------------------------------------------------------------------------------------
function addVideoRow( tbl )
	// Add an empty row to hold the video player when needed
{
	// Add an empty row to show the video clip
	var row = tbl.insertRow();
	row.vAlign = "top";
	
	var cell = row.insertCell();
	cell.className = "video";
	cell.colSpan = kTocColCnt;
	cell.innerHTML = "&nbsp;";				
}

//-----------------------------------------------------------------------------------------------
function renderTocItem( item )
{	
	var bGovInstr = false;
	
	var s = "";
	if( !item.title ) return s;
	
	gTocIdCnt++;
	var id = "tocItem" + gTocIdCnt;
	
	s = '<a id="' + id + '" href="javascript:';
	
	if( item.screenId )
	{
		s += 'parent.';
		
		switch( item.type )
		{
			case "prghelp":	s += 'hyperToPrgHelp'; break;
			case "hyper":		s += 'hyperTo'; break;
		}
		
		s += '(null,\'';
		s += item.screenId;
		s += '\')';
	}
	else if( item.video )
	{
		s += 'goClip(\'';
		s += id
		s += '\',\'';
		s += item.video;
		s += '\')';
	}
	else if( item.toc )
	{
		s += 'goToc(\'';
		s += item.type;
		s += '\',\'';
		s += item.toc;
		s += '\')';
	}
	else
	{
		switch( item.type )
		{
			case "videolib":
				s += 'goVideoLibrary()';
				break;
				
			case "govinstr":
				s += 'goGovHelp()';
				bGovInstr = true;
				break;
		}
	}
		
	s += '">';
	if( bGovInstr )
	{
		parent.onCmd("isFederalContext");
		s += ( "yes" == parent.getLastCmdResult() ) ? "IRS " : "Government ";		
	}
	s += item.title;
	s += '</a>';

	return s;
}

function renderTocButton( item )
{
	//<table cellpadding="0" cellspacing="0" onmouseover="this.style.backgroundColor='#B2D3FF'"
	//			onmouseout="this.style.background='#ffffff'" onclick="HelpBtn.click()">
	//	<tr>
	//		<td class="leftNavButtons">Find Tax Help</td>
	//		<td class="leftNavButtons">
	//			<img id="HelpBtn" style="VERTICAL-ALIGN:middle" src="../img/gry_arrowicon_right.gif">
	//		</td>
	//	</tr>
	//</table>
	var sFunction = renderTocFunction( item );
	var tableHtml = "<table width='100%'";
	tableHtml += appendAttr("cellspacing","0");
	tableHtml += appendAttr("cellpadding","0");
	tableHtml += appendAttr("border","0");
	tableHtml += appendAttr("onmouseover","this.style.backgroundColor='#B2D3FF'");
	tableHtml += appendAttr("onmouseout","this.style.background='#ffffff'");
	tableHtml += appendAttr("onclick",sFunction);
	tableHtml += "><tr width='100%'><td";
	tableHtml += appendAttr("class","leftNavButtons");
	tableHtml += ">";
	if (item.helpTitle == null)
		tableHtml += item.title;
	else
		tableHtml += item.helpTitle;
	tableHtml += "</td></tr>";
	tableHtml += "<tr><td height='1px' bgcolor='#cccccc'></td></tr></table>";
	return tableHtml;
}

function renderTocFunction( item )
{
	var bGovInstr = false;
	var s = "javascript:";
	if( item.screenId )
	{
		s += 'parent.';
		
		switch( item.type )
		{
			case "prghelp":	s += 'hyperToPrgHelp'; break;
			case "hyper":		s += 'hyperTo'; break;
		}
		
		s += '(null,\'';
		s += item.screenId;
		s += '\')';
	}
	else if( item.video )
	{
		s += 'goClip(\'';
		s += id
		s += '\',\'';
		s += item.video;
		s += '\')';
	}
	else if( item.toc )
	{
		s += 'goToc(\'';
		s += item.type;
		s += '\',\'';
		s += item.toc;
		s += '\')';
	}
	else
	{
		switch( item.type )
		{
			case "videolib":
				s += 'goVideoLibrary()';
				break;
			case "moreinfo":
				s+='goMoreInfo()';
				break;
		}
	}
		
	return s;
}

//-----------------------------------------------------------------------------------------------
function getTocSections( filename, variant )
	// Returns a collection of zTocSection objects read from the specified XML file
{
	if( !filename ) return null;
	
	var xml = parent.getXMLParser();
	if( parent.loadXml( xml, filename ) )
	{
		var nodes = xml.selectNodes( "/content//section" );
		var cnt = nodes.length;
		if( cnt > 0 ) 
		{	
			var sections = new Array( cnt );
			for( var i=0; i<cnt; ++i ) sections[i] = new zTocSection( nodes[i] );

			return sections;
		}
	}
		
	return null;	
}

//-----------------------------------------------------------------------------------------------
// zTocSection
//-----------------------------------------------------------------------------------------------
function zTocSection( node )
	// Initializes a TOC section from the specified XML section node
	// A section is a collection of toc items nodes
{
	if( !node ) return;
	
	var child = null;
	var cnt = node.childNodes.length;
	
	for( var i=0; i<cnt; ++i )
	{
		child = node.childNodes[i];
		
		switch( child.nodeName )
		{
			case "title":
				this.title = child.text;
				break;
			
			case "items":
				var itmCnt = child.childNodes.length;
				if( itmCnt > 0 )
				{
					this.items = new Array( itmCnt );
					
					for( var k=0; k<itmCnt; ++k )
					{
						if( "item" == child.childNodes[k].nodeName )
						{
							this.items[k] = new zTocItem( child.childNodes[k] );
						}	
					}
				}	
				break;
		}
	}
}

//-----------------------------------------------------------------------------------------------
p = zTocSection.prototype;
p.title = null;
p.items = null;

p = null;


//-----------------------------------------------------------------------------------------------
// zTocItem
//-----------------------------------------------------------------------------------------------
function zTocItem( node )
	// Initializes a TOC item from an specified xml item node
{
	if( !node ) return;
	
	var child = null;
	var cnt = node.childNodes.length;
	
	for( var i=0; i<cnt; ++i )
	{
		child = node.childNodes[i];
		
		switch( child.nodeName )
		{
			case "title":		this.title = child.text; break;
			case "helpTitle":	this.helpTitle = child.text; break;
			case "type":		this.type = child.text.toLowerCase(); break;
			case "screen_id":	this.screenId = child.text.toLowerCase(); break;
			case "full_row":  this.bFullRow = (child.text.toLowerCase()=="yes"); break;
			case "video":		this.video = child.text.toLowerCase(); break;
			case "toc":			this.toc = child.text.toLowerCase(); break;
			case "id":			this.id = child.text.toLowerCase(); break;
			
			case "graphic":		
				this.graphic = child.text.toLowerCase(); 
				break;
			
			case "variant_set":
				var vCnt = child.childNodes.length;
				if( vCnt>0 )
				{
					this.variants = new Array( vCnt );
					
					for( var vi=0; vi<vCnt; ++vi )
					{
						if( "variant" == child.childNodes[vi].nodeName )
						{
							this.variants[vi] = child.childNodes[vi].text.toLowerCase();
						}	
					}
				}	
				break;

			case "channel_set":
				var vCnt = child.childNodes.length;
				if( vCnt>0 )
				{
					this.channels = new Array( vCnt );
					
					for( var ci=0; ci<vCnt; ++ci )
					{
						if( "channel" == child.childNodes[ci].nodeName )
						{
							this.channels[ci] = child.childNodes[ci].text.toLowerCase();
						}
					}
				}
				break;

		}
	}
}

//-----------------------------------------------------------------------------------------------
function _zTocItemIsApplicable( variant, channel )
	// Returns true if the item is applicable to the specified variant and channel
{
	var bVariantApplicable = true;	
	if( variant && this.variants )
	{
		// Check if specified varient is specified in the variant set
		bVariantApplicable = false;

		var cnt = this.variants.length;
		if( 1 == cnt && "all" == this.variants[0] ) bVariantApplicable = true; 
		else
		{
			var name = variant.toLowerCase();
			for( var i=0; i<cnt; ++i )
			{
				if( name==this.variants[i] )
				{
					bVariantApplicable = true;
					break;
				}
			}
		}
	}

	var bChannelApplicable = true;
	if( channel && this.channels )
	{
		// Check if specified channel is specified in the channel set
		bChannelApplicable = false;

		var cnt = this.channels.length;
		if( 1 == cnt && "all" == this.channels[0] ) bChannelApplicable = true; 
		else
		{
			var name = channel.toLowerCase();
			for( var i=0; i<cnt; ++i )
			{
				if( name==this.channels[i] )
				{
					bChannelApplicable = true;
					break;
				}
			}
		}
	}

	return ( bVariantApplicable && bChannelApplicable );
}

//-----------------------------------------------------------------------------------------------
p = zTocItem.prototype;
p.title = null;
p.helpTitle = null;		// possibly a different title than in the app (abbreviated)
p.type = null;
p.screenId = null;
p.bFullRow = false;
p.video = null;
p.toc = null;
p.graphic = null;
p.id = null;
p.variants = null;
p.channels = null;

p.isApplicable = _zTocItemIsApplicable

p = null;
